package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__string, __timestampIso8601}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class JobSummary(
    bucketDefinitions: Optional[
      Iterable[zio.aws.macie2.model.S3BucketDefinitionForJob]
    ] = Optional.Absent,
    createdAt: Optional[__timestampIso8601] = Optional.Absent,
    jobId: Optional[__string] = Optional.Absent,
    jobStatus: Optional[zio.aws.macie2.model.JobStatus] = Optional.Absent,
    jobType: Optional[zio.aws.macie2.model.JobType] = Optional.Absent,
    lastRunErrorStatus: Optional[zio.aws.macie2.model.LastRunErrorStatus] =
      Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    userPausedDetails: Optional[zio.aws.macie2.model.UserPausedDetails] =
      Optional.Absent,
    bucketCriteria: Optional[zio.aws.macie2.model.S3BucketCriteriaForJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.JobSummary
      .builder()
      .optionallyWith(
        bucketDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bucketDefinitions)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(lastRunErrorStatus.map(value => value.buildAwsValue()))(
        _.lastRunErrorStatus
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(userPausedDetails.map(value => value.buildAwsValue()))(
        _.userPausedDetails
      )
      .optionallyWith(bucketCriteria.map(value => value.buildAwsValue()))(
        _.bucketCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.JobSummary.ReadOnly =
    zio.aws.macie2.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.JobSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.JobSummary =
      zio.aws.macie2.model.JobSummary(
        bucketDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        jobId.map(value => value),
        jobStatus.map(value => value),
        jobType.map(value => value),
        lastRunErrorStatus.map(value => value.asEditable),
        name.map(value => value),
        userPausedDetails.map(value => value.asEditable),
        bucketCriteria.map(value => value.asEditable)
      )
    def bucketDefinitions
        : Optional[List[zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly]]
    def createdAt: Optional[__timestampIso8601]
    def jobId: Optional[__string]
    def jobStatus: Optional[zio.aws.macie2.model.JobStatus]
    def jobType: Optional[zio.aws.macie2.model.JobType]
    def lastRunErrorStatus
        : Optional[zio.aws.macie2.model.LastRunErrorStatus.ReadOnly]
    def name: Optional[__string]
    def userPausedDetails
        : Optional[zio.aws.macie2.model.UserPausedDetails.ReadOnly]
    def bucketCriteria
        : Optional[zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly]
    def getBucketDefinitions: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly
    ]] = AwsError.unwrapOptionField("bucketDefinitions", bucketDefinitions)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.macie2.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getJobType: ZIO[Any, AwsError, zio.aws.macie2.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getLastRunErrorStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.LastRunErrorStatus.ReadOnly] =
      AwsError.unwrapOptionField("lastRunErrorStatus", lastRunErrorStatus)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getUserPausedDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.UserPausedDetails.ReadOnly] =
      AwsError.unwrapOptionField("userPausedDetails", userPausedDetails)
    def getBucketCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly
    ] = AwsError.unwrapOptionField("bucketCriteria", bucketCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.JobSummary
  ) extends zio.aws.macie2.model.JobSummary.ReadOnly {
    override val bucketDefinitions: Optional[
      List[zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.S3BucketDefinitionForJob.wrap(item)
        }.toList
      )
    override val createdAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __timestampIso8601)
    override val jobId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: __string)
    override val jobStatus: Optional[zio.aws.macie2.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.macie2.model.JobStatus.wrap(value))
    override val jobType: Optional[zio.aws.macie2.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.macie2.model.JobType.wrap(value))
    override val lastRunErrorStatus
        : Optional[zio.aws.macie2.model.LastRunErrorStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunErrorStatus())
        .map(value => zio.aws.macie2.model.LastRunErrorStatus.wrap(value))
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val userPausedDetails
        : Optional[zio.aws.macie2.model.UserPausedDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPausedDetails())
        .map(value => zio.aws.macie2.model.UserPausedDetails.wrap(value))
    override val bucketCriteria
        : Optional[zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketCriteria())
        .map(value => zio.aws.macie2.model.S3BucketCriteriaForJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.JobSummary
  ): zio.aws.macie2.model.JobSummary.ReadOnly = new Wrapper(impl)
}
