package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateClassificationJobResponse(
    jobArn: Optional[__string] = Optional.Absent,
    jobId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse = {
    import CreateClassificationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse
      .builder()
      .optionallyWith(jobArn.map(value => value: java.lang.String))(_.jobArn)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly =
    zio.aws.macie2.model.CreateClassificationJobResponse.wrap(buildAwsValue())
}
object CreateClassificationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateClassificationJobResponse =
      zio.aws.macie2.model.CreateClassificationJobResponse(
        jobArn.map(value => value),
        jobId.map(value => value)
      )
    def jobArn: Optional[__string]
    def jobId: Optional[__string]
    def getJobArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse
  ) extends zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly {
    override val jobArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => value: __string)
    override val jobId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse
  ): zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly =
    new Wrapper(impl)
}
