package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UsageRecord(
    accountId: Optional[__string] = Optional.Absent,
    freeTrialStartDate: Optional[__timestampIso8601] = Optional.Absent,
    usage: Optional[Iterable[zio.aws.macie2.model.UsageByAccount]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UsageRecord = {
    import UsageRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UsageRecord
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(freeTrialStartDate.map(value => value: Instant))(
        _.freeTrialStartDate
      )
      .optionallyWith(
        usage.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usage)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UsageRecord.ReadOnly =
    zio.aws.macie2.model.UsageRecord.wrap(buildAwsValue())
}
object UsageRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UsageRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UsageRecord =
      zio.aws.macie2.model.UsageRecord(
        accountId.map(value => value),
        freeTrialStartDate.map(value => value),
        usage.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountId: Optional[__string]
    def freeTrialStartDate: Optional[__timestampIso8601]
    def usage: Optional[List[zio.aws.macie2.model.UsageByAccount.ReadOnly]]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getFreeTrialStartDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("freeTrialStartDate", freeTrialStartDate)
    def getUsage: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.UsageByAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("usage", usage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UsageRecord
  ) extends zio.aws.macie2.model.UsageRecord.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val freeTrialStartDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.freeTrialStartDate())
        .map(value => value: __timestampIso8601)
    override val usage
        : Optional[List[zio.aws.macie2.model.UsageByAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usage())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.UsageByAccount.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UsageRecord
  ): zio.aws.macie2.model.UsageRecord.ReadOnly = new Wrapper(impl)
}
