package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__timestampIso8601, __long}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetBucketStatisticsResponse(
    bucketCount: Optional[__long] = Optional.Absent,
    bucketCountByEffectivePermission: Optional[
      zio.aws.macie2.model.BucketCountByEffectivePermission
    ] = Optional.Absent,
    bucketCountByEncryptionType: Optional[
      zio.aws.macie2.model.BucketCountByEncryptionType
    ] = Optional.Absent,
    bucketCountByObjectEncryptionRequirement: Optional[
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
    ] = Optional.Absent,
    bucketCountBySharedAccessType: Optional[
      zio.aws.macie2.model.BucketCountBySharedAccessType
    ] = Optional.Absent,
    classifiableObjectCount: Optional[__long] = Optional.Absent,
    classifiableSizeInBytes: Optional[__long] = Optional.Absent,
    lastUpdated: Optional[__timestampIso8601] = Optional.Absent,
    objectCount: Optional[__long] = Optional.Absent,
    sizeInBytes: Optional[__long] = Optional.Absent,
    sizeInBytesCompressed: Optional[__long] = Optional.Absent,
    unclassifiableObjectCount: Optional[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = Optional.Absent,
    unclassifiableObjectSizeInBytes: Optional[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse = {
    import GetBucketStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse
      .builder()
      .optionallyWith(bucketCount.map(value => value: java.lang.Long))(
        _.bucketCount
      )
      .optionallyWith(
        bucketCountByEffectivePermission.map(value => value.buildAwsValue())
      )(_.bucketCountByEffectivePermission)
      .optionallyWith(
        bucketCountByEncryptionType.map(value => value.buildAwsValue())
      )(_.bucketCountByEncryptionType)
      .optionallyWith(
        bucketCountByObjectEncryptionRequirement.map(value =>
          value.buildAwsValue()
        )
      )(_.bucketCountByObjectEncryptionRequirement)
      .optionallyWith(
        bucketCountBySharedAccessType.map(value => value.buildAwsValue())
      )(_.bucketCountBySharedAccessType)
      .optionallyWith(
        classifiableObjectCount.map(value => value: java.lang.Long)
      )(_.classifiableObjectCount)
      .optionallyWith(
        classifiableSizeInBytes.map(value => value: java.lang.Long)
      )(_.classifiableSizeInBytes)
      .optionallyWith(lastUpdated.map(value => value: Instant))(_.lastUpdated)
      .optionallyWith(objectCount.map(value => value: java.lang.Long))(
        _.objectCount
      )
      .optionallyWith(sizeInBytes.map(value => value: java.lang.Long))(
        _.sizeInBytes
      )
      .optionallyWith(
        sizeInBytesCompressed.map(value => value: java.lang.Long)
      )(_.sizeInBytesCompressed)
      .optionallyWith(
        unclassifiableObjectCount.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectCount)
      .optionallyWith(
        unclassifiableObjectSizeInBytes.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectSizeInBytes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly =
    zio.aws.macie2.model.GetBucketStatisticsResponse.wrap(buildAwsValue())
}
object GetBucketStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetBucketStatisticsResponse =
      zio.aws.macie2.model.GetBucketStatisticsResponse(
        bucketCount.map(value => value),
        bucketCountByEffectivePermission.map(value => value.asEditable),
        bucketCountByEncryptionType.map(value => value.asEditable),
        bucketCountByObjectEncryptionRequirement.map(value => value.asEditable),
        bucketCountBySharedAccessType.map(value => value.asEditable),
        classifiableObjectCount.map(value => value),
        classifiableSizeInBytes.map(value => value),
        lastUpdated.map(value => value),
        objectCount.map(value => value),
        sizeInBytes.map(value => value),
        sizeInBytesCompressed.map(value => value),
        unclassifiableObjectCount.map(value => value.asEditable),
        unclassifiableObjectSizeInBytes.map(value => value.asEditable)
      )
    def bucketCount: Optional[__long]
    def bucketCountByEffectivePermission: Optional[
      zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly
    ]
    def bucketCountByEncryptionType
        : Optional[zio.aws.macie2.model.BucketCountByEncryptionType.ReadOnly]
    def bucketCountByObjectEncryptionRequirement: Optional[
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly
    ]
    def bucketCountBySharedAccessType
        : Optional[zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly]
    def classifiableObjectCount: Optional[__long]
    def classifiableSizeInBytes: Optional[__long]
    def lastUpdated: Optional[__timestampIso8601]
    def objectCount: Optional[__long]
    def sizeInBytes: Optional[__long]
    def sizeInBytesCompressed: Optional[__long]
    def unclassifiableObjectCount
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def unclassifiableObjectSizeInBytes
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def getBucketCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("bucketCount", bucketCount)
    def getBucketCountByEffectivePermission: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketCountByEffectivePermission",
      bucketCountByEffectivePermission
    )
    def getBucketCountByEncryptionType: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketCountByEncryptionType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketCountByEncryptionType",
      bucketCountByEncryptionType
    )
    def getBucketCountByObjectEncryptionRequirement: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketCountByObjectEncryptionRequirement",
      bucketCountByObjectEncryptionRequirement
    )
    def getBucketCountBySharedAccessType: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketCountBySharedAccessType",
      bucketCountBySharedAccessType
    )
    def getClassifiableObjectCount: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableObjectCount", classifiableObjectCount)
    def getClassifiableSizeInBytes: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableSizeInBytes", classifiableSizeInBytes)
    def getLastUpdated: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getObjectCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("objectCount", objectCount)
    def getSizeInBytes: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getSizeInBytesCompressed: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytesCompressed", sizeInBytesCompressed)
    def getUnclassifiableObjectCount: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectCount",
      unclassifiableObjectCount
    )
    def getUnclassifiableObjectSizeInBytes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectSizeInBytes",
      unclassifiableObjectSizeInBytes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse
  ) extends zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly {
    override val bucketCount: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketCount())
      .map(value => value: __long)
    override val bucketCountByEffectivePermission: Optional[
      zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketCountByEffectivePermission())
      .map(value =>
        zio.aws.macie2.model.BucketCountByEffectivePermission.wrap(value)
      )
    override val bucketCountByEncryptionType
        : Optional[zio.aws.macie2.model.BucketCountByEncryptionType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketCountByEncryptionType())
        .map(value =>
          zio.aws.macie2.model.BucketCountByEncryptionType.wrap(value)
        )
    override val bucketCountByObjectEncryptionRequirement: Optional[
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketCountByObjectEncryptionRequirement())
      .map(value =>
        zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
          .wrap(value)
      )
    override val bucketCountBySharedAccessType: Optional[
      zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketCountBySharedAccessType())
      .map(value =>
        zio.aws.macie2.model.BucketCountBySharedAccessType.wrap(value)
      )
    override val classifiableObjectCount: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifiableObjectCount())
        .map(value => value: __long)
    override val classifiableSizeInBytes: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifiableSizeInBytes())
        .map(value => value: __long)
    override val lastUpdated: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdated())
        .map(value => value: __timestampIso8601)
    override val objectCount: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.objectCount())
      .map(value => value: __long)
    override val sizeInBytes: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInBytes())
      .map(value => value: __long)
    override val sizeInBytesCompressed: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInBytesCompressed())
      .map(value => value: __long)
    override val unclassifiableObjectCount
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unclassifiableObjectCount())
        .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
    override val unclassifiableObjectSizeInBytes
        : Optional[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unclassifiableObjectSizeInBytes())
        .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse
  ): zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly = new Wrapper(
    impl
  )
}
