package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait FindingType {
  def unwrap: software.amazon.awssdk.services.macie2.model.FindingType
}
object FindingType {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.FindingType
  ): zio.aws.macie2.model.FindingType = value match {
    case software.amazon.awssdk.services.macie2.model.FindingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_MULTIPLE =>
      val r = `SensitiveData:S3Object/Multiple`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_FINANCIAL =>
      val r = `SensitiveData:S3Object/Financial`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_PERSONAL =>
      val r = `SensitiveData:S3Object/Personal`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_CREDENTIALS =>
      val r = `SensitiveData:S3Object/Credentials`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_CUSTOM_IDENTIFIER =>
      val r = `SensitiveData:S3Object/CustomIdentifier`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BUCKET_PUBLIC =>
      val r = `Policy:IAMUser/S3BucketPublic`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BUCKET_SHARED_EXTERNALLY =>
      val r = `Policy:IAMUser/S3BucketSharedExternally`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BUCKET_REPLICATED_EXTERNALLY =>
      val r = `Policy:IAMUser/S3BucketReplicatedExternally`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BUCKET_ENCRYPTION_DISABLED =>
      val r = `Policy:IAMUser/S3BucketEncryptionDisabled`
      r
    case software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BLOCK_PUBLIC_ACCESS_DISABLED =>
      val r = `Policy:IAMUser/S3BlockPublicAccessDisabled`
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.UNKNOWN_TO_SDK_VERSION
  }
  case object `SensitiveData:S3Object/Multiple`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_MULTIPLE
  }
  case object `SensitiveData:S3Object/Financial`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_FINANCIAL
  }
  case object `SensitiveData:S3Object/Personal`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_PERSONAL
  }
  case object `SensitiveData:S3Object/Credentials`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_CREDENTIALS
  }
  case object `SensitiveData:S3Object/CustomIdentifier`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.SENSITIVE_DATA_S3_OBJECT_CUSTOM_IDENTIFIER
  }
  case object `Policy:IAMUser/S3BucketPublic`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BUCKET_PUBLIC
  }
  case object `Policy:IAMUser/S3BucketSharedExternally`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BUCKET_SHARED_EXTERNALLY
  }
  case object `Policy:IAMUser/S3BucketReplicatedExternally`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BUCKET_REPLICATED_EXTERNALLY
  }
  case object `Policy:IAMUser/S3BucketEncryptionDisabled`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BUCKET_ENCRYPTION_DISABLED
  }
  case object `Policy:IAMUser/S3BlockPublicAccessDisabled`
      extends zio.aws.macie2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingType =
      software.amazon.awssdk.services.macie2.model.FindingType.POLICY_IAM_USER_S3_BLOCK_PUBLIC_ACCESS_DISABLED
  }
}
