package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ObjectLevelStatistics(
    fileType: Optional[__long] = Optional.Absent,
    storageClass: Optional[__long] = Optional.Absent,
    total: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics = {
    import ObjectLevelStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics
      .builder()
      .optionallyWith(fileType.map(value => value: java.lang.Long))(_.fileType)
      .optionallyWith(storageClass.map(value => value: java.lang.Long))(
        _.storageClass
      )
      .optionallyWith(total.map(value => value: java.lang.Long))(_.total)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly =
    zio.aws.macie2.model.ObjectLevelStatistics.wrap(buildAwsValue())
}
object ObjectLevelStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ObjectLevelStatistics =
      zio.aws.macie2.model.ObjectLevelStatistics(
        fileType.map(value => value),
        storageClass.map(value => value),
        total.map(value => value)
      )
    def fileType: Optional[__long]
    def storageClass: Optional[__long]
    def total: Optional[__long]
    def getFileType: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("fileType", fileType)
    def getStorageClass: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getTotal: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics
  ) extends zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly {
    override val fileType: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.fileType())
      .map(value => value: __long)
    override val storageClass: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.storageClass())
      .map(value => value: __long)
    override val total: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics
  ): zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly = new Wrapper(impl)
}
