package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  __integer,
  __boolean,
  __timestampIso8601,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeClassificationJobResponse(
    clientToken: Optional[__string] = Optional.Absent,
    createdAt: Optional[__timestampIso8601] = Optional.Absent,
    customDataIdentifierIds: Optional[Iterable[__string]] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    initialRun: Optional[__boolean] = Optional.Absent,
    jobArn: Optional[__string] = Optional.Absent,
    jobId: Optional[__string] = Optional.Absent,
    jobStatus: Optional[zio.aws.macie2.model.JobStatus] = Optional.Absent,
    jobType: Optional[zio.aws.macie2.model.JobType] = Optional.Absent,
    lastRunErrorStatus: Optional[zio.aws.macie2.model.LastRunErrorStatus] =
      Optional.Absent,
    lastRunTime: Optional[__timestampIso8601] = Optional.Absent,
    managedDataIdentifierIds: Optional[Iterable[__string]] = Optional.Absent,
    managedDataIdentifierSelector: Optional[
      zio.aws.macie2.model.ManagedDataIdentifierSelector
    ] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    s3JobDefinition: Optional[zio.aws.macie2.model.S3JobDefinition] =
      Optional.Absent,
    samplingPercentage: Optional[__integer] = Optional.Absent,
    scheduleFrequency: Optional[zio.aws.macie2.model.JobScheduleFrequency] =
      Optional.Absent,
    statistics: Optional[zio.aws.macie2.model.Statistics] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    userPausedDetails: Optional[zio.aws.macie2.model.UserPausedDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse = {
    import DescribeClassificationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(
        customDataIdentifierIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.customDataIdentifierIds)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(initialRun.map(value => value: java.lang.Boolean))(
        _.initialRun
      )
      .optionallyWith(jobArn.map(value => value: java.lang.String))(_.jobArn)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(lastRunErrorStatus.map(value => value.buildAwsValue()))(
        _.lastRunErrorStatus
      )
      .optionallyWith(lastRunTime.map(value => value: Instant))(_.lastRunTime)
      .optionallyWith(
        managedDataIdentifierIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.managedDataIdentifierIds)
      .optionallyWith(managedDataIdentifierSelector.map(value => value.unwrap))(
        _.managedDataIdentifierSelector
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(s3JobDefinition.map(value => value.buildAwsValue()))(
        _.s3JobDefinition
      )
      .optionallyWith(samplingPercentage.map(value => value: Integer))(
        _.samplingPercentage
      )
      .optionallyWith(scheduleFrequency.map(value => value.buildAwsValue()))(
        _.scheduleFrequency
      )
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(userPausedDetails.map(value => value.buildAwsValue()))(
        _.userPausedDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly =
    zio.aws.macie2.model.DescribeClassificationJobResponse.wrap(buildAwsValue())
}
object DescribeClassificationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DescribeClassificationJobResponse =
      zio.aws.macie2.model.DescribeClassificationJobResponse(
        clientToken.map(value => value),
        createdAt.map(value => value),
        customDataIdentifierIds.map(value => value),
        description.map(value => value),
        initialRun.map(value => value),
        jobArn.map(value => value),
        jobId.map(value => value),
        jobStatus.map(value => value),
        jobType.map(value => value),
        lastRunErrorStatus.map(value => value.asEditable),
        lastRunTime.map(value => value),
        managedDataIdentifierIds.map(value => value),
        managedDataIdentifierSelector.map(value => value),
        name.map(value => value),
        s3JobDefinition.map(value => value.asEditable),
        samplingPercentage.map(value => value),
        scheduleFrequency.map(value => value.asEditable),
        statistics.map(value => value.asEditable),
        tags.map(value => value),
        userPausedDetails.map(value => value.asEditable)
      )
    def clientToken: Optional[__string]
    def createdAt: Optional[__timestampIso8601]
    def customDataIdentifierIds: Optional[List[__string]]
    def description: Optional[__string]
    def initialRun: Optional[__boolean]
    def jobArn: Optional[__string]
    def jobId: Optional[__string]
    def jobStatus: Optional[zio.aws.macie2.model.JobStatus]
    def jobType: Optional[zio.aws.macie2.model.JobType]
    def lastRunErrorStatus
        : Optional[zio.aws.macie2.model.LastRunErrorStatus.ReadOnly]
    def lastRunTime: Optional[__timestampIso8601]
    def managedDataIdentifierIds: Optional[List[__string]]
    def managedDataIdentifierSelector
        : Optional[zio.aws.macie2.model.ManagedDataIdentifierSelector]
    def name: Optional[__string]
    def s3JobDefinition: Optional[zio.aws.macie2.model.S3JobDefinition.ReadOnly]
    def samplingPercentage: Optional[__integer]
    def scheduleFrequency
        : Optional[zio.aws.macie2.model.JobScheduleFrequency.ReadOnly]
    def statistics: Optional[zio.aws.macie2.model.Statistics.ReadOnly]
    def tags: Optional[Map[__string, __string]]
    def userPausedDetails
        : Optional[zio.aws.macie2.model.UserPausedDetails.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCustomDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "customDataIdentifierIds",
        customDataIdentifierIds
      )
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getInitialRun: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("initialRun", initialRun)
    def getJobArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.macie2.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getJobType: ZIO[Any, AwsError, zio.aws.macie2.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getLastRunErrorStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.LastRunErrorStatus.ReadOnly] =
      AwsError.unwrapOptionField("lastRunErrorStatus", lastRunErrorStatus)
    def getLastRunTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastRunTime", lastRunTime)
    def getManagedDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "managedDataIdentifierIds",
        managedDataIdentifierIds
      )
    def getManagedDataIdentifierSelector: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ManagedDataIdentifierSelector
    ] = AwsError.unwrapOptionField(
      "managedDataIdentifierSelector",
      managedDataIdentifierSelector
    )
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getS3JobDefinition
        : ZIO[Any, AwsError, zio.aws.macie2.model.S3JobDefinition.ReadOnly] =
      AwsError.unwrapOptionField("s3JobDefinition", s3JobDefinition)
    def getSamplingPercentage: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("samplingPercentage", samplingPercentage)
    def getScheduleFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.JobScheduleFrequency.ReadOnly
    ] = AwsError.unwrapOptionField("scheduleFrequency", scheduleFrequency)
    def getStatistics
        : ZIO[Any, AwsError, zio.aws.macie2.model.Statistics.ReadOnly] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserPausedDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.UserPausedDetails.ReadOnly] =
      AwsError.unwrapOptionField("userPausedDetails", userPausedDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse
  ) extends zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly {
    override val clientToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: __string)
    override val createdAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __timestampIso8601)
    override val customDataIdentifierIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDataIdentifierIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val initialRun: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.initialRun())
      .map(value => value: __boolean)
    override val jobArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => value: __string)
    override val jobId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: __string)
    override val jobStatus: Optional[zio.aws.macie2.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.macie2.model.JobStatus.wrap(value))
    override val jobType: Optional[zio.aws.macie2.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.macie2.model.JobType.wrap(value))
    override val lastRunErrorStatus
        : Optional[zio.aws.macie2.model.LastRunErrorStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunErrorStatus())
        .map(value => zio.aws.macie2.model.LastRunErrorStatus.wrap(value))
    override val lastRunTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunTime())
        .map(value => value: __timestampIso8601)
    override val managedDataIdentifierIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedDataIdentifierIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val managedDataIdentifierSelector
        : Optional[zio.aws.macie2.model.ManagedDataIdentifierSelector] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedDataIdentifierSelector())
        .map(value =>
          zio.aws.macie2.model.ManagedDataIdentifierSelector.wrap(value)
        )
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val s3JobDefinition
        : Optional[zio.aws.macie2.model.S3JobDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3JobDefinition())
        .map(value => zio.aws.macie2.model.S3JobDefinition.wrap(value))
    override val samplingPercentage: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.samplingPercentage())
      .map(value => value: __integer)
    override val scheduleFrequency
        : Optional[zio.aws.macie2.model.JobScheduleFrequency.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleFrequency())
        .map(value => zio.aws.macie2.model.JobScheduleFrequency.wrap(value))
    override val statistics
        : Optional[zio.aws.macie2.model.Statistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.macie2.model.Statistics.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val userPausedDetails
        : Optional[zio.aws.macie2.model.UserPausedDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPausedDetails())
        .map(value => zio.aws.macie2.model.UserPausedDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse
  ): zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly =
    new Wrapper(impl)
}
