package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCustomDataIdentifierResponse(
    customDataIdentifierId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse = {
    import CreateCustomDataIdentifierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse
      .builder()
      .optionallyWith(
        customDataIdentifierId.map(value => value: java.lang.String)
      )(_.customDataIdentifierId)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.CreateCustomDataIdentifierResponse.ReadOnly =
    zio.aws.macie2.model.CreateCustomDataIdentifierResponse
      .wrap(buildAwsValue())
}
object CreateCustomDataIdentifierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateCustomDataIdentifierResponse =
      zio.aws.macie2.model.CreateCustomDataIdentifierResponse(
        customDataIdentifierId.map(value => value)
      )
    def customDataIdentifierId: Optional[__string]
    def getCustomDataIdentifierId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("customDataIdentifierId", customDataIdentifierId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse
  ) extends zio.aws.macie2.model.CreateCustomDataIdentifierResponse.ReadOnly {
    override val customDataIdentifierId: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDataIdentifierId())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse
  ): zio.aws.macie2.model.CreateCustomDataIdentifierResponse.ReadOnly =
    new Wrapper(impl)
}
