package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SortCriteria(
    attributeName: Option[__string] = None,
    orderBy: Option[zio.aws.macie2.model.OrderBy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SortCriteria = {
    import SortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SortCriteria
      .builder()
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(orderBy.map(value => value.unwrap))(_.orderBy)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SortCriteria.ReadOnly =
    zio.aws.macie2.model.SortCriteria.wrap(buildAwsValue())
}
object SortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SortCriteria =
      zio.aws.macie2.model.SortCriteria(
        attributeName.map(value => value),
        orderBy.map(value => value)
      )
    def attributeName: Option[__string]
    def orderBy: Option[zio.aws.macie2.model.OrderBy]
    def getAttributeName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getOrderBy: ZIO[Any, AwsError, zio.aws.macie2.model.OrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SortCriteria
  ) extends zio.aws.macie2.model.SortCriteria.ReadOnly {
    override val attributeName: Option[__string] =
      scala.Option(impl.attributeName()).map(value => value: __string)
    override val orderBy: Option[zio.aws.macie2.model.OrderBy] = scala
      .Option(impl.orderBy())
      .map(value => zio.aws.macie2.model.OrderBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SortCriteria
  ): zio.aws.macie2.model.SortCriteria.ReadOnly = new Wrapper(impl)
}
