package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SearchResourcesSimpleCriterion(
    comparator: Option[zio.aws.macie2.model.SearchResourcesComparator] = None,
    key: Option[zio.aws.macie2.model.SearchResourcesSimpleCriterionKey] = None,
    values: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SearchResourcesSimpleCriterion = {
    import SearchResourcesSimpleCriterion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SearchResourcesSimpleCriterion
      .builder()
      .optionallyWith(comparator.map(value => value.unwrap))(_.comparator)
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SearchResourcesSimpleCriterion.ReadOnly =
    zio.aws.macie2.model.SearchResourcesSimpleCriterion.wrap(buildAwsValue())
}
object SearchResourcesSimpleCriterion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SearchResourcesSimpleCriterion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SearchResourcesSimpleCriterion =
      zio.aws.macie2.model.SearchResourcesSimpleCriterion(
        comparator.map(value => value),
        key.map(value => value),
        values.map(value => value)
      )
    def comparator: Option[zio.aws.macie2.model.SearchResourcesComparator]
    def key: Option[zio.aws.macie2.model.SearchResourcesSimpleCriterionKey]
    def values: Option[List[__string]]
    def getComparator
        : ZIO[Any, AwsError, zio.aws.macie2.model.SearchResourcesComparator] =
      AwsError.unwrapOptionField("comparator", comparator)
    def getKey: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SearchResourcesSimpleCriterionKey
    ] = AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesSimpleCriterion
  ) extends zio.aws.macie2.model.SearchResourcesSimpleCriterion.ReadOnly {
    override val comparator
        : Option[zio.aws.macie2.model.SearchResourcesComparator] = scala
      .Option(impl.comparator())
      .map(value => zio.aws.macie2.model.SearchResourcesComparator.wrap(value))
    override val key
        : Option[zio.aws.macie2.model.SearchResourcesSimpleCriterionKey] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.macie2.model.SearchResourcesSimpleCriterionKey.wrap(value)
      )
    override val values: Option[List[__string]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesSimpleCriterion
  ): zio.aws.macie2.model.SearchResourcesSimpleCriterion.ReadOnly = new Wrapper(
    impl
  )
}
