package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters.*
final case class SearchResourcesRequest(
    bucketCriteria: Option[zio.aws.macie2.model.SearchResourcesBucketCriteria] =
      None,
    maxResults: Option[__integer] = None,
    nextToken: Option[__string] = None,
    sortCriteria: Option[zio.aws.macie2.model.SearchResourcesSortCriteria] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SearchResourcesRequest = {
    import SearchResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SearchResourcesRequest
      .builder()
      .optionallyWith(bucketCriteria.map(value => value.buildAwsValue()))(
        _.bucketCriteria
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SearchResourcesRequest.ReadOnly =
    zio.aws.macie2.model.SearchResourcesRequest.wrap(buildAwsValue())
}
object SearchResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SearchResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SearchResourcesRequest =
      zio.aws.macie2.model.SearchResourcesRequest(
        bucketCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortCriteria.map(value => value.asEditable)
      )
    def bucketCriteria
        : Option[zio.aws.macie2.model.SearchResourcesBucketCriteria.ReadOnly]
    def maxResults: Option[__integer]
    def nextToken: Option[__string]
    def sortCriteria
        : Option[zio.aws.macie2.model.SearchResourcesSortCriteria.ReadOnly]
    def getBucketCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SearchResourcesBucketCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("bucketCriteria", bucketCriteria)
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SearchResourcesSortCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesRequest
  ) extends zio.aws.macie2.model.SearchResourcesRequest.ReadOnly {
    override val bucketCriteria
        : Option[zio.aws.macie2.model.SearchResourcesBucketCriteria.ReadOnly] =
      scala
        .Option(impl.bucketCriteria())
        .map(value =>
          zio.aws.macie2.model.SearchResourcesBucketCriteria.wrap(value)
        )
    override val maxResults: Option[__integer] =
      scala.Option(impl.maxResults()).map(value => value: __integer)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val sortCriteria
        : Option[zio.aws.macie2.model.SearchResourcesSortCriteria.ReadOnly] =
      scala
        .Option(impl.sortCriteria())
        .map(value =>
          zio.aws.macie2.model.SearchResourcesSortCriteria.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesRequest
  ): zio.aws.macie2.model.SearchResourcesRequest.ReadOnly = new Wrapper(impl)
}
