package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchResourcesBucketCriteria(
    excludes: Option[zio.aws.macie2.model.SearchResourcesCriteriaBlock] = None,
    includes: Option[zio.aws.macie2.model.SearchResourcesCriteriaBlock] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SearchResourcesBucketCriteria = {
    import SearchResourcesBucketCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SearchResourcesBucketCriteria
      .builder()
      .optionallyWith(excludes.map(value => value.buildAwsValue()))(_.excludes)
      .optionallyWith(includes.map(value => value.buildAwsValue()))(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SearchResourcesBucketCriteria.ReadOnly =
    zio.aws.macie2.model.SearchResourcesBucketCriteria.wrap(buildAwsValue())
}
object SearchResourcesBucketCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SearchResourcesBucketCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SearchResourcesBucketCriteria =
      zio.aws.macie2.model.SearchResourcesBucketCriteria(
        excludes.map(value => value.asEditable),
        includes.map(value => value.asEditable)
      )
    def excludes
        : Option[zio.aws.macie2.model.SearchResourcesCriteriaBlock.ReadOnly]
    def includes
        : Option[zio.aws.macie2.model.SearchResourcesCriteriaBlock.ReadOnly]
    def getExcludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SearchResourcesCriteriaBlock.ReadOnly
    ] = AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SearchResourcesCriteriaBlock.ReadOnly
    ] = AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesBucketCriteria
  ) extends zio.aws.macie2.model.SearchResourcesBucketCriteria.ReadOnly {
    override val excludes
        : Option[zio.aws.macie2.model.SearchResourcesCriteriaBlock.ReadOnly] =
      scala
        .Option(impl.excludes())
        .map(value =>
          zio.aws.macie2.model.SearchResourcesCriteriaBlock.wrap(value)
        )
    override val includes
        : Option[zio.aws.macie2.model.SearchResourcesCriteriaBlock.ReadOnly] =
      scala
        .Option(impl.includes())
        .map(value =>
          zio.aws.macie2.model.SearchResourcesCriteriaBlock.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesBucketCriteria
  ): zio.aws.macie2.model.SearchResourcesBucketCriteria.ReadOnly = new Wrapper(
    impl
  )
}
