package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters.*
final case class MatchingBucket(
    accountId: Option[__string] = None,
    bucketName: Option[__string] = None,
    classifiableObjectCount: Option[__long] = None,
    classifiableSizeInBytes: Option[__long] = None,
    errorCode: Option[zio.aws.macie2.model.BucketMetadataErrorCode] = None,
    errorMessage: Option[__string] = None,
    jobDetails: Option[zio.aws.macie2.model.JobDetails] = None,
    objectCount: Option[__long] = None,
    objectCountByEncryptionType: Option[
      zio.aws.macie2.model.ObjectCountByEncryptionType
    ] = None,
    sizeInBytes: Option[__long] = None,
    sizeInBytesCompressed: Option[__long] = None,
    unclassifiableObjectCount: Option[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = None,
    unclassifiableObjectSizeInBytes: Option[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.MatchingBucket = {
    import MatchingBucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.MatchingBucket
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(
        classifiableObjectCount.map(value => value: java.lang.Long)
      )(_.classifiableObjectCount)
      .optionallyWith(
        classifiableSizeInBytes.map(value => value: java.lang.Long)
      )(_.classifiableSizeInBytes)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .optionallyWith(objectCount.map(value => value: java.lang.Long))(
        _.objectCount
      )
      .optionallyWith(
        objectCountByEncryptionType.map(value => value.buildAwsValue())
      )(_.objectCountByEncryptionType)
      .optionallyWith(sizeInBytes.map(value => value: java.lang.Long))(
        _.sizeInBytes
      )
      .optionallyWith(
        sizeInBytesCompressed.map(value => value: java.lang.Long)
      )(_.sizeInBytesCompressed)
      .optionallyWith(
        unclassifiableObjectCount.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectCount)
      .optionallyWith(
        unclassifiableObjectSizeInBytes.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectSizeInBytes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.MatchingBucket.ReadOnly =
    zio.aws.macie2.model.MatchingBucket.wrap(buildAwsValue())
}
object MatchingBucket {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.MatchingBucket
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.MatchingBucket =
      zio.aws.macie2.model.MatchingBucket(
        accountId.map(value => value),
        bucketName.map(value => value),
        classifiableObjectCount.map(value => value),
        classifiableSizeInBytes.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        jobDetails.map(value => value.asEditable),
        objectCount.map(value => value),
        objectCountByEncryptionType.map(value => value.asEditable),
        sizeInBytes.map(value => value),
        sizeInBytesCompressed.map(value => value),
        unclassifiableObjectCount.map(value => value.asEditable),
        unclassifiableObjectSizeInBytes.map(value => value.asEditable)
      )
    def accountId: Option[__string]
    def bucketName: Option[__string]
    def classifiableObjectCount: Option[__long]
    def classifiableSizeInBytes: Option[__long]
    def errorCode: Option[zio.aws.macie2.model.BucketMetadataErrorCode]
    def errorMessage: Option[__string]
    def jobDetails: Option[zio.aws.macie2.model.JobDetails.ReadOnly]
    def objectCount: Option[__long]
    def objectCountByEncryptionType
        : Option[zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly]
    def sizeInBytes: Option[__long]
    def sizeInBytesCompressed: Option[__long]
    def unclassifiableObjectCount
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def unclassifiableObjectSizeInBytes
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getBucketName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getClassifiableObjectCount: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableObjectCount", classifiableObjectCount)
    def getClassifiableSizeInBytes: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableSizeInBytes", classifiableSizeInBytes)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketMetadataErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getJobDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.JobDetails.ReadOnly] =
      AwsError.unwrapOptionField("jobDetails", jobDetails)
    def getObjectCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("objectCount", objectCount)
    def getObjectCountByEncryptionType: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectCountByEncryptionType",
      objectCountByEncryptionType
    )
    def getSizeInBytes: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getSizeInBytesCompressed: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytesCompressed", sizeInBytesCompressed)
    def getUnclassifiableObjectCount: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectCount",
      unclassifiableObjectCount
    )
    def getUnclassifiableObjectSizeInBytes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectSizeInBytes",
      unclassifiableObjectSizeInBytes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.MatchingBucket
  ) extends zio.aws.macie2.model.MatchingBucket.ReadOnly {
    override val accountId: Option[__string] =
      scala.Option(impl.accountId()).map(value => value: __string)
    override val bucketName: Option[__string] =
      scala.Option(impl.bucketName()).map(value => value: __string)
    override val classifiableObjectCount: Option[__long] =
      scala.Option(impl.classifiableObjectCount()).map(value => value: __long)
    override val classifiableSizeInBytes: Option[__long] =
      scala.Option(impl.classifiableSizeInBytes()).map(value => value: __long)
    override val errorCode
        : Option[zio.aws.macie2.model.BucketMetadataErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.macie2.model.BucketMetadataErrorCode.wrap(value))
    override val errorMessage: Option[__string] =
      scala.Option(impl.errorMessage()).map(value => value: __string)
    override val jobDetails: Option[zio.aws.macie2.model.JobDetails.ReadOnly] =
      scala
        .Option(impl.jobDetails())
        .map(value => zio.aws.macie2.model.JobDetails.wrap(value))
    override val objectCount: Option[__long] =
      scala.Option(impl.objectCount()).map(value => value: __long)
    override val objectCountByEncryptionType
        : Option[zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly] =
      scala
        .Option(impl.objectCountByEncryptionType())
        .map(value =>
          zio.aws.macie2.model.ObjectCountByEncryptionType.wrap(value)
        )
    override val sizeInBytes: Option[__long] =
      scala.Option(impl.sizeInBytes()).map(value => value: __long)
    override val sizeInBytesCompressed: Option[__long] =
      scala.Option(impl.sizeInBytesCompressed()).map(value => value: __long)
    override val unclassifiableObjectCount
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] = scala
      .Option(impl.unclassifiableObjectCount())
      .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
    override val unclassifiableObjectSizeInBytes
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] = scala
      .Option(impl.unclassifiableObjectSizeInBytes())
      .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.MatchingBucket
  ): zio.aws.macie2.model.MatchingBucket.ReadOnly = new Wrapper(impl)
}
