package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ManagedDataIdentifierSummary(
    category: Option[zio.aws.macie2.model.SensitiveDataItemCategory] = None,
    id: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary = {
    import ManagedDataIdentifierSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary
      .builder()
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly =
    zio.aws.macie2.model.ManagedDataIdentifierSummary.wrap(buildAwsValue())
}
object ManagedDataIdentifierSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ManagedDataIdentifierSummary =
      zio.aws.macie2.model.ManagedDataIdentifierSummary(
        category.map(value => value),
        id.map(value => value)
      )
    def category: Option[zio.aws.macie2.model.SensitiveDataItemCategory]
    def id: Option[__string]
    def getCategory
        : ZIO[Any, AwsError, zio.aws.macie2.model.SensitiveDataItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary
  ) extends zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly {
    override val category
        : Option[zio.aws.macie2.model.SensitiveDataItemCategory] = scala
      .Option(impl.category())
      .map(value => zio.aws.macie2.model.SensitiveDataItemCategory.wrap(value))
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary
  ): zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly = new Wrapper(
    impl
  )
}
