package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListManagedDataIdentifiersResponse(
    items: Option[Iterable[zio.aws.macie2.model.ManagedDataIdentifierSummary]] =
      None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse = {
    import ListManagedDataIdentifiersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListManagedDataIdentifiersResponse.ReadOnly =
    zio.aws.macie2.model.ListManagedDataIdentifiersResponse
      .wrap(buildAwsValue())
}
object ListManagedDataIdentifiersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListManagedDataIdentifiersResponse =
      zio.aws.macie2.model.ListManagedDataIdentifiersResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[
      List[zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly]
    ]
    def nextToken: Option[__string]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse
  ) extends zio.aws.macie2.model.ListManagedDataIdentifiersResponse.ReadOnly {
    override val items: Option[
      List[zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.ManagedDataIdentifierSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse
  ): zio.aws.macie2.model.ListManagedDataIdentifiersResponse.ReadOnly =
    new Wrapper(impl)
}
