package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJobsSortCriteria(
    attributeName: Option[zio.aws.macie2.model.ListJobsSortAttributeName] =
      None,
    orderBy: Option[zio.aws.macie2.model.OrderBy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria = {
    import ListJobsSortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria
      .builder()
      .optionallyWith(attributeName.map(value => value.unwrap))(_.attributeName)
      .optionallyWith(orderBy.map(value => value.unwrap))(_.orderBy)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly =
    zio.aws.macie2.model.ListJobsSortCriteria.wrap(buildAwsValue())
}
object ListJobsSortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListJobsSortCriteria =
      zio.aws.macie2.model.ListJobsSortCriteria(
        attributeName.map(value => value),
        orderBy.map(value => value)
      )
    def attributeName: Option[zio.aws.macie2.model.ListJobsSortAttributeName]
    def orderBy: Option[zio.aws.macie2.model.OrderBy]
    def getAttributeName
        : ZIO[Any, AwsError, zio.aws.macie2.model.ListJobsSortAttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getOrderBy: ZIO[Any, AwsError, zio.aws.macie2.model.OrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria
  ) extends zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly {
    override val attributeName
        : Option[zio.aws.macie2.model.ListJobsSortAttributeName] = scala
      .Option(impl.attributeName())
      .map(value => zio.aws.macie2.model.ListJobsSortAttributeName.wrap(value))
    override val orderBy: Option[zio.aws.macie2.model.OrderBy] = scala
      .Option(impl.orderBy())
      .map(value => zio.aws.macie2.model.OrderBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria
  ): zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly = new Wrapper(impl)
}
