package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __timestampIso8601}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetMacieSessionResponse(
    createdAt: Option[__timestampIso8601] = None,
    findingPublishingFrequency: Option[
      zio.aws.macie2.model.FindingPublishingFrequency
    ] = None,
    serviceRole: Option[__string] = None,
    status: Option[zio.aws.macie2.model.MacieStatus] = None,
    updatedAt: Option[__timestampIso8601] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse = {
    import GetMacieSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse
      .builder()
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(findingPublishingFrequency.map(value => value.unwrap))(
        _.findingPublishingFrequency
      )
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(updatedAt.map(value => value: Instant))(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly =
    zio.aws.macie2.model.GetMacieSessionResponse.wrap(buildAwsValue())
}
object GetMacieSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetMacieSessionResponse =
      zio.aws.macie2.model.GetMacieSessionResponse(
        createdAt.map(value => value),
        findingPublishingFrequency.map(value => value),
        serviceRole.map(value => value),
        status.map(value => value),
        updatedAt.map(value => value)
      )
    def createdAt: Option[__timestampIso8601]
    def findingPublishingFrequency
        : Option[zio.aws.macie2.model.FindingPublishingFrequency]
    def serviceRole: Option[__string]
    def status: Option[zio.aws.macie2.model.MacieStatus]
    def updatedAt: Option[__timestampIso8601]
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFindingPublishingFrequency
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingPublishingFrequency] =
      AwsError.unwrapOptionField(
        "findingPublishingFrequency",
        findingPublishingFrequency
      )
    def getServiceRole: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getStatus: ZIO[Any, AwsError, zio.aws.macie2.model.MacieStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse
  ) extends zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly {
    override val createdAt: Option[__timestampIso8601] =
      scala.Option(impl.createdAt()).map(value => value: __timestampIso8601)
    override val findingPublishingFrequency
        : Option[zio.aws.macie2.model.FindingPublishingFrequency] = scala
      .Option(impl.findingPublishingFrequency())
      .map(value => zio.aws.macie2.model.FindingPublishingFrequency.wrap(value))
    override val serviceRole: Option[__string] =
      scala.Option(impl.serviceRole()).map(value => value: __string)
    override val status: Option[zio.aws.macie2.model.MacieStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.macie2.model.MacieStatus.wrap(value))
    override val updatedAt: Option[__timestampIso8601] =
      scala.Option(impl.updatedAt()).map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse
  ): zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly = new Wrapper(impl)
}
