package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import scala.jdk.CollectionConverters.*
final case class GetInvitationsCountResponse(
    invitationsCount: Option[__long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse = {
    import GetInvitationsCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse
      .builder()
      .optionallyWith(invitationsCount.map(value => value: java.lang.Long))(
        _.invitationsCount
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetInvitationsCountResponse.ReadOnly =
    zio.aws.macie2.model.GetInvitationsCountResponse.wrap(buildAwsValue())
}
object GetInvitationsCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetInvitationsCountResponse =
      zio.aws.macie2.model
        .GetInvitationsCountResponse(invitationsCount.map(value => value))
    def invitationsCount: Option[__long]
    def getInvitationsCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("invitationsCount", invitationsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse
  ) extends zio.aws.macie2.model.GetInvitationsCountResponse.ReadOnly {
    override val invitationsCount: Option[__long] =
      scala.Option(impl.invitationsCount()).map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse
  ): zio.aws.macie2.model.GetInvitationsCountResponse.ReadOnly = new Wrapper(
    impl
  )
}
