package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class GetFindingsFilterResponse(
    action: Option[zio.aws.macie2.model.FindingsFilterAction] = None,
    arn: Option[__string] = None,
    description: Option[__string] = None,
    findingCriteria: Option[zio.aws.macie2.model.FindingCriteria] = None,
    id: Option[__string] = None,
    name: Option[__string] = None,
    position: Option[__integer] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse = {
    import GetFindingsFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(position.map(value => value: Integer))(_.position)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly =
    zio.aws.macie2.model.GetFindingsFilterResponse.wrap(buildAwsValue())
}
object GetFindingsFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetFindingsFilterResponse =
      zio.aws.macie2.model.GetFindingsFilterResponse(
        action.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        findingCriteria.map(value => value.asEditable),
        id.map(value => value),
        name.map(value => value),
        position.map(value => value),
        tags.map(value => value)
      )
    def action: Option[zio.aws.macie2.model.FindingsFilterAction]
    def arn: Option[__string]
    def description: Option[__string]
    def findingCriteria: Option[zio.aws.macie2.model.FindingCriteria.ReadOnly]
    def id: Option[__string]
    def name: Option[__string]
    def position: Option[__integer]
    def tags: Option[Map[__string, __string]]
    def getAction
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingsFilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPosition: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("position", position)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse
  ) extends zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly {
    override val action: Option[zio.aws.macie2.model.FindingsFilterAction] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.macie2.model.FindingsFilterAction.wrap(value))
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val findingCriteria
        : Option[zio.aws.macie2.model.FindingCriteria.ReadOnly] = scala
      .Option(impl.findingCriteria())
      .map(value => zio.aws.macie2.model.FindingCriteria.wrap(value))
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val position: Option[__integer] =
      scala.Option(impl.position()).map(value => value: __integer)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse
  ): zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly = new Wrapper(impl)
}
