package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__boolean
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConfigurationResponse(
    autoEnable: Option[__boolean] = None,
    maxAccountLimitReached: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse = {
    import DescribeOrganizationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse
      .builder()
      .optionallyWith(autoEnable.map(value => value: java.lang.Boolean))(
        _.autoEnable
      )
      .optionallyWith(
        maxAccountLimitReached.map(value => value: java.lang.Boolean)
      )(_.maxAccountLimitReached)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    zio.aws.macie2.model.DescribeOrganizationConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.DescribeOrganizationConfigurationResponse =
      zio.aws.macie2.model.DescribeOrganizationConfigurationResponse(
        autoEnable.map(value => value),
        maxAccountLimitReached.map(value => value)
      )
    def autoEnable: Option[__boolean]
    def maxAccountLimitReached: Option[__boolean]
    def getAutoEnable: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("autoEnable", autoEnable)
    def getMaxAccountLimitReached: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("maxAccountLimitReached", maxAccountLimitReached)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse
  ) extends zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.ReadOnly {
    override val autoEnable: Option[__boolean] =
      scala.Option(impl.autoEnable()).map(value => value: __boolean)
    override val maxAccountLimitReached: Option[__boolean] =
      scala.Option(impl.maxAccountLimitReached()).map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse
  ): zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
