package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateClassificationJobResponse(
    jobArn: Option[__string] = None,
    jobId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse = {
    import CreateClassificationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse
      .builder()
      .optionallyWith(jobArn.map(value => value: java.lang.String))(_.jobArn)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly =
    zio.aws.macie2.model.CreateClassificationJobResponse.wrap(buildAwsValue())
}
object CreateClassificationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateClassificationJobResponse =
      zio.aws.macie2.model.CreateClassificationJobResponse(
        jobArn.map(value => value),
        jobId.map(value => value)
      )
    def jobArn: Option[__string]
    def jobId: Option[__string]
    def getJobArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse
  ) extends zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly {
    override val jobArn: Option[__string] =
      scala.Option(impl.jobArn()).map(value => value: __string)
    override val jobId: Option[__string] =
      scala.Option(impl.jobId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse
  ): zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly =
    new Wrapper(impl)
}
