package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ServerSideEncryption(
    encryptionType: Option[zio.aws.macie2.model.EncryptionType] = None,
    kmsMasterKeyId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ServerSideEncryption = {
    import ServerSideEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ServerSideEncryption
      .builder()
      .optionallyWith(encryptionType.map(value => value.unwrap))(
        _.encryptionType
      )
      .optionallyWith(kmsMasterKeyId.map(value => value: java.lang.String))(
        _.kmsMasterKeyId
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ServerSideEncryption.ReadOnly =
    zio.aws.macie2.model.ServerSideEncryption.wrap(buildAwsValue())
}
object ServerSideEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ServerSideEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ServerSideEncryption =
      zio.aws.macie2.model.ServerSideEncryption(
        encryptionType.map(value => value),
        kmsMasterKeyId.map(value => value)
      )
    def encryptionType: Option[zio.aws.macie2.model.EncryptionType]
    def kmsMasterKeyId: Option[__string]
    def getEncryptionType
        : ZIO[Any, AwsError, zio.aws.macie2.model.EncryptionType] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getKmsMasterKeyId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ServerSideEncryption
  ) extends zio.aws.macie2.model.ServerSideEncryption.ReadOnly {
    override val encryptionType: Option[zio.aws.macie2.model.EncryptionType] =
      scala
        .Option(impl.encryptionType())
        .map(value => zio.aws.macie2.model.EncryptionType.wrap(value))
    override val kmsMasterKeyId: Option[__string] =
      scala.Option(impl.kmsMasterKeyId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ServerSideEncryption
  ): zio.aws.macie2.model.ServerSideEncryption.ReadOnly = new Wrapper(impl)
}
