package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchResourcesCriteria(
    simpleCriterion: Option[
      zio.aws.macie2.model.SearchResourcesSimpleCriterion
    ] = None,
    tagCriterion: Option[zio.aws.macie2.model.SearchResourcesTagCriterion] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SearchResourcesCriteria = {
    import SearchResourcesCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SearchResourcesCriteria
      .builder()
      .optionallyWith(simpleCriterion.map(value => value.buildAwsValue()))(
        _.simpleCriterion
      )
      .optionallyWith(tagCriterion.map(value => value.buildAwsValue()))(
        _.tagCriterion
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SearchResourcesCriteria.ReadOnly =
    zio.aws.macie2.model.SearchResourcesCriteria.wrap(buildAwsValue())
}
object SearchResourcesCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SearchResourcesCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SearchResourcesCriteria =
      zio.aws.macie2.model.SearchResourcesCriteria(
        simpleCriterion.map(value => value.asEditable),
        tagCriterion.map(value => value.asEditable)
      )
    def simpleCriterion
        : Option[zio.aws.macie2.model.SearchResourcesSimpleCriterion.ReadOnly]
    def tagCriterion
        : Option[zio.aws.macie2.model.SearchResourcesTagCriterion.ReadOnly]
    def getSimpleCriterion: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SearchResourcesSimpleCriterion.ReadOnly
    ] = AwsError.unwrapOptionField("simpleCriterion", simpleCriterion)
    def getTagCriterion: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SearchResourcesTagCriterion.ReadOnly
    ] = AwsError.unwrapOptionField("tagCriterion", tagCriterion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesCriteria
  ) extends zio.aws.macie2.model.SearchResourcesCriteria.ReadOnly {
    override val simpleCriterion
        : Option[zio.aws.macie2.model.SearchResourcesSimpleCriterion.ReadOnly] =
      scala
        .Option(impl.simpleCriterion())
        .map(value =>
          zio.aws.macie2.model.SearchResourcesSimpleCriterion.wrap(value)
        )
    override val tagCriterion
        : Option[zio.aws.macie2.model.SearchResourcesTagCriterion.ReadOnly] =
      scala
        .Option(impl.tagCriterion())
        .map(value =>
          zio.aws.macie2.model.SearchResourcesTagCriterion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesCriteria
  ): zio.aws.macie2.model.SearchResourcesCriteria.ReadOnly = new Wrapper(impl)
}
