package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import scala.jdk.CollectionConverters.*
final case class ObjectLevelStatistics(
    fileType: Option[__long] = None,
    storageClass: Option[__long] = None,
    total: Option[__long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics = {
    import ObjectLevelStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics
      .builder()
      .optionallyWith(fileType.map(value => value: java.lang.Long))(_.fileType)
      .optionallyWith(storageClass.map(value => value: java.lang.Long))(
        _.storageClass
      )
      .optionallyWith(total.map(value => value: java.lang.Long))(_.total)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly =
    zio.aws.macie2.model.ObjectLevelStatistics.wrap(buildAwsValue())
}
object ObjectLevelStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ObjectLevelStatistics =
      zio.aws.macie2.model.ObjectLevelStatistics(
        fileType.map(value => value),
        storageClass.map(value => value),
        total.map(value => value)
      )
    def fileType: Option[__long]
    def storageClass: Option[__long]
    def total: Option[__long]
    def getFileType: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("fileType", fileType)
    def getStorageClass: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getTotal: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics
  ) extends zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly {
    override val fileType: Option[__long] =
      scala.Option(impl.fileType()).map(value => value: __long)
    override val storageClass: Option[__long] =
      scala.Option(impl.storageClass()).map(value => value: __long)
    override val total: Option[__long] =
      scala.Option(impl.total()).map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics
  ): zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly = new Wrapper(impl)
}
