package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListInvitationsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListInvitationsRequest = {
    import ListInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListInvitationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListInvitationsRequest.ReadOnly =
    zio.aws.macie2.model.ListInvitationsRequest.wrap(buildAwsValue())
}
object ListInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListInvitationsRequest =
      zio.aws.macie2.model.ListInvitationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListInvitationsRequest
  ) extends zio.aws.macie2.model.ListInvitationsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.macie2.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListInvitationsRequest
  ): zio.aws.macie2.model.ListInvitationsRequest.ReadOnly = new Wrapper(impl)
}
