package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class FindingsFilterListItem(
    action: Option[zio.aws.macie2.model.FindingsFilterAction] = None,
    arn: Option[__string] = None,
    id: Option[__string] = None,
    name: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.FindingsFilterListItem = {
    import FindingsFilterListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.FindingsFilterListItem
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.FindingsFilterListItem.ReadOnly =
    zio.aws.macie2.model.FindingsFilterListItem.wrap(buildAwsValue())
}
object FindingsFilterListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.FindingsFilterListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.FindingsFilterListItem =
      zio.aws.macie2.model.FindingsFilterListItem(
        action.map(value => value),
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        tags.map(value => value)
      )
    def action: Option[zio.aws.macie2.model.FindingsFilterAction]
    def arn: Option[__string]
    def id: Option[__string]
    def name: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getAction
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingsFilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.FindingsFilterListItem
  ) extends zio.aws.macie2.model.FindingsFilterListItem.ReadOnly {
    override val action: Option[zio.aws.macie2.model.FindingsFilterAction] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.macie2.model.FindingsFilterAction.wrap(value))
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.FindingsFilterListItem
  ): zio.aws.macie2.model.FindingsFilterListItem.ReadOnly = new Wrapper(impl)
}
