package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FindingAction(
    actionType: Option[zio.aws.macie2.model.FindingActionType] = None,
    apiCallDetails: Option[zio.aws.macie2.model.ApiCallDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.FindingAction = {
    import FindingAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.FindingAction
      .builder()
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(apiCallDetails.map(value => value.buildAwsValue()))(
        _.apiCallDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.FindingAction.ReadOnly =
    zio.aws.macie2.model.FindingAction.wrap(buildAwsValue())
}
object FindingAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.FindingAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.FindingAction =
      zio.aws.macie2.model.FindingAction(
        actionType.map(value => value),
        apiCallDetails.map(value => value.asEditable)
      )
    def actionType: Option[zio.aws.macie2.model.FindingActionType]
    def apiCallDetails: Option[zio.aws.macie2.model.ApiCallDetails.ReadOnly]
    def getActionType
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getApiCallDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.ApiCallDetails.ReadOnly] =
      AwsError.unwrapOptionField("apiCallDetails", apiCallDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.FindingAction
  ) extends zio.aws.macie2.model.FindingAction.ReadOnly {
    override val actionType: Option[zio.aws.macie2.model.FindingActionType] =
      scala
        .Option(impl.actionType())
        .map(value => zio.aws.macie2.model.FindingActionType.wrap(value))
    override val apiCallDetails
        : Option[zio.aws.macie2.model.ApiCallDetails.ReadOnly] = scala
      .Option(impl.apiCallDetails())
      .map(value => zio.aws.macie2.model.ApiCallDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.FindingAction
  ): zio.aws.macie2.model.FindingAction.ReadOnly = new Wrapper(impl)
}
