package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UsageRecord(
    accountId: Option[__string] = None,
    freeTrialStartDate: Option[__timestampIso8601] = None,
    usage: Option[Iterable[zio.aws.macie2.model.UsageByAccount]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UsageRecord = {
    import UsageRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UsageRecord
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(freeTrialStartDate.map(value => value: Instant))(
        _.freeTrialStartDate
      )
      .optionallyWith(
        usage.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usage)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UsageRecord.ReadOnly =
    zio.aws.macie2.model.UsageRecord.wrap(buildAwsValue())
}
object UsageRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UsageRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UsageRecord =
      zio.aws.macie2.model.UsageRecord(
        accountId.map(value => value),
        freeTrialStartDate.map(value => value),
        usage.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountId: Option[__string]
    def freeTrialStartDate: Option[__timestampIso8601]
    def usage: Option[List[zio.aws.macie2.model.UsageByAccount.ReadOnly]]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getFreeTrialStartDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("freeTrialStartDate", freeTrialStartDate)
    def getUsage: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.UsageByAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("usage", usage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UsageRecord
  ) extends zio.aws.macie2.model.UsageRecord.ReadOnly {
    override val accountId: Option[__string] =
      scala.Option(impl.accountId()).map(value => value: __string)
    override val freeTrialStartDate: Option[__timestampIso8601] = scala
      .Option(impl.freeTrialStartDate())
      .map(value => value: __timestampIso8601)
    override val usage
        : Option[List[zio.aws.macie2.model.UsageByAccount.ReadOnly]] = scala
      .Option(impl.usage())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.UsageByAccount.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UsageRecord
  ): zio.aws.macie2.model.UsageRecord.ReadOnly = new Wrapper(impl)
}
