package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class TestCustomDataIdentifierRequest(
    ignoreWords: Option[Iterable[__string]] = None,
    keywords: Option[Iterable[__string]] = None,
    maximumMatchDistance: Option[__integer] = None,
    regex: __string,
    sampleText: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest = {
    import TestCustomDataIdentifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest
      .builder()
      .optionallyWith(
        ignoreWords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ignoreWords)
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(maximumMatchDistance.map(value => value: Integer))(
        _.maximumMatchDistance
      )
      .regex(regex: java.lang.String)
      .sampleText(sampleText: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.TestCustomDataIdentifierRequest.ReadOnly =
    zio.aws.macie2.model.TestCustomDataIdentifierRequest.wrap(buildAwsValue())
}
object TestCustomDataIdentifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.TestCustomDataIdentifierRequest =
      zio.aws.macie2.model.TestCustomDataIdentifierRequest(
        ignoreWords.map(value => value),
        keywords.map(value => value),
        maximumMatchDistance.map(value => value),
        regex,
        sampleText
      )
    def ignoreWords: Option[List[__string]]
    def keywords: Option[List[__string]]
    def maximumMatchDistance: Option[__integer]
    def regex: __string
    def sampleText: __string
    def getIgnoreWords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("ignoreWords", ignoreWords)
    def getKeywords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getMaximumMatchDistance: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maximumMatchDistance", maximumMatchDistance)
    def getRegex: ZIO[Any, Nothing, __string] = ZIO.succeed(regex)
    def getSampleText: ZIO[Any, Nothing, __string] = ZIO.succeed(sampleText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest
  ) extends zio.aws.macie2.model.TestCustomDataIdentifierRequest.ReadOnly {
    override val ignoreWords: Option[List[__string]] = scala
      .Option(impl.ignoreWords())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val keywords: Option[List[__string]] = scala
      .Option(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val maximumMatchDistance: Option[__integer] =
      scala.Option(impl.maximumMatchDistance()).map(value => value: __integer)
    override val regex: __string = impl.regex(): __string
    override val sampleText: __string = impl.sampleText(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest
  ): zio.aws.macie2.model.TestCustomDataIdentifierRequest.ReadOnly =
    new Wrapper(impl)
}
