package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__double
import scala.jdk.CollectionConverters.*
final case class Statistics(
    approximateNumberOfObjectsToProcess: Option[__double] = None,
    numberOfRuns: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.Statistics = {
    import Statistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Statistics
      .builder()
      .optionallyWith(
        approximateNumberOfObjectsToProcess.map(value =>
          value: java.lang.Double
        )
      )(_.approximateNumberOfObjectsToProcess)
      .optionallyWith(numberOfRuns.map(value => value: java.lang.Double))(
        _.numberOfRuns
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Statistics.ReadOnly =
    zio.aws.macie2.model.Statistics.wrap(buildAwsValue())
}
object Statistics {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Statistics] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Statistics =
      zio.aws.macie2.model.Statistics(
        approximateNumberOfObjectsToProcess.map(value => value),
        numberOfRuns.map(value => value)
      )
    def approximateNumberOfObjectsToProcess: Option[__double]
    def numberOfRuns: Option[__double]
    def getApproximateNumberOfObjectsToProcess: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField(
        "approximateNumberOfObjectsToProcess",
        approximateNumberOfObjectsToProcess
      )
    def getNumberOfRuns: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("numberOfRuns", numberOfRuns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Statistics
  ) extends zio.aws.macie2.model.Statistics.ReadOnly {
    override val approximateNumberOfObjectsToProcess: Option[__double] = scala
      .Option(impl.approximateNumberOfObjectsToProcess())
      .map(value => value: __double)
    override val numberOfRuns: Option[__double] =
      scala.Option(impl.numberOfRuns()).map(value => value: __double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Statistics
  ): zio.aws.macie2.model.Statistics.ReadOnly = new Wrapper(impl)
}
