package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait MacieStatus {
  def unwrap: software.amazon.awssdk.services.macie2.model.MacieStatus
}
object MacieStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.MacieStatus
  ): zio.aws.macie2.model.MacieStatus = value match {
    case software.amazon.awssdk.services.macie2.model.MacieStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.MacieStatus.PAUSED =>
      val r = PAUSED
      r
    case software.amazon.awssdk.services.macie2.model.MacieStatus.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.MacieStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.MacieStatus =
      software.amazon.awssdk.services.macie2.model.MacieStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PAUSED extends zio.aws.macie2.model.MacieStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.MacieStatus =
      software.amazon.awssdk.services.macie2.model.MacieStatus.PAUSED
  }
  case object ENABLED extends zio.aws.macie2.model.MacieStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.MacieStatus =
      software.amazon.awssdk.services.macie2.model.MacieStatus.ENABLED
  }
}
