package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters.*
final case class ListClassificationJobsRequest(
    filterCriteria: Option[zio.aws.macie2.model.ListJobsFilterCriteria] = None,
    maxResults: Option[__integer] = None,
    nextToken: Option[__string] = None,
    sortCriteria: Option[zio.aws.macie2.model.ListJobsSortCriteria] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest = {
    import ListClassificationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest
      .builder()
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListClassificationJobsRequest.ReadOnly =
    zio.aws.macie2.model.ListClassificationJobsRequest.wrap(buildAwsValue())
}
object ListClassificationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListClassificationJobsRequest =
      zio.aws.macie2.model.ListClassificationJobsRequest(
        filterCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortCriteria.map(value => value.asEditable)
      )
    def filterCriteria
        : Option[zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly]
    def maxResults: Option[__integer]
    def nextToken: Option[__string]
    def sortCriteria: Option[zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly]
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest
  ) extends zio.aws.macie2.model.ListClassificationJobsRequest.ReadOnly {
    override val filterCriteria
        : Option[zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly] = scala
      .Option(impl.filterCriteria())
      .map(value => zio.aws.macie2.model.ListJobsFilterCriteria.wrap(value))
    override val maxResults: Option[__integer] =
      scala.Option(impl.maxResults()).map(value => value: __integer)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val sortCriteria
        : Option[zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly] = scala
      .Option(impl.sortCriteria())
      .map(value => zio.aws.macie2.model.ListJobsSortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest
  ): zio.aws.macie2.model.ListClassificationJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
