package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class IpCountry(
    code: Option[__string] = None,
    name: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.IpCountry = {
    import IpCountry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.IpCountry
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.IpCountry.ReadOnly =
    zio.aws.macie2.model.IpCountry.wrap(buildAwsValue())
}
object IpCountry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.IpCountry] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.IpCountry = zio.aws.macie2.model
      .IpCountry(code.map(value => value), name.map(value => value))
    def code: Option[__string]
    def name: Option[__string]
    def getCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("code", code)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.IpCountry
  ) extends zio.aws.macie2.model.IpCountry.ReadOnly {
    override val code: Option[__string] =
      scala.Option(impl.code()).map(value => value: __string)
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.IpCountry
  ): zio.aws.macie2.model.IpCountry.ReadOnly = new Wrapper(impl)
}
