package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FindingStatisticsSortCriteria(
    attributeName: Option[
      zio.aws.macie2.model.FindingStatisticsSortAttributeName
    ] = None,
    orderBy: Option[zio.aws.macie2.model.OrderBy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.FindingStatisticsSortCriteria = {
    import FindingStatisticsSortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.FindingStatisticsSortCriteria
      .builder()
      .optionallyWith(attributeName.map(value => value.unwrap))(_.attributeName)
      .optionallyWith(orderBy.map(value => value.unwrap))(_.orderBy)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.FindingStatisticsSortCriteria.ReadOnly =
    zio.aws.macie2.model.FindingStatisticsSortCriteria.wrap(buildAwsValue())
}
object FindingStatisticsSortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.FindingStatisticsSortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.FindingStatisticsSortCriteria =
      zio.aws.macie2.model.FindingStatisticsSortCriteria(
        attributeName.map(value => value),
        orderBy.map(value => value)
      )
    def attributeName
        : Option[zio.aws.macie2.model.FindingStatisticsSortAttributeName]
    def orderBy: Option[zio.aws.macie2.model.OrderBy]
    def getAttributeName: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.FindingStatisticsSortAttributeName
    ] = AwsError.unwrapOptionField("attributeName", attributeName)
    def getOrderBy: ZIO[Any, AwsError, zio.aws.macie2.model.OrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.FindingStatisticsSortCriteria
  ) extends zio.aws.macie2.model.FindingStatisticsSortCriteria.ReadOnly {
    override val attributeName
        : Option[zio.aws.macie2.model.FindingStatisticsSortAttributeName] =
      scala
        .Option(impl.attributeName())
        .map(value =>
          zio.aws.macie2.model.FindingStatisticsSortAttributeName.wrap(value)
        )
    override val orderBy: Option[zio.aws.macie2.model.OrderBy] = scala
      .Option(impl.orderBy())
      .map(value => zio.aws.macie2.model.OrderBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.FindingStatisticsSortCriteria
  ): zio.aws.macie2.model.FindingStatisticsSortCriteria.ReadOnly = new Wrapper(
    impl
  )
}
