package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EnableMacieRequest(
    clientToken: Option[__string] = None,
    findingPublishingFrequency: Option[
      zio.aws.macie2.model.FindingPublishingFrequency
    ] = None,
    status: Option[zio.aws.macie2.model.MacieStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.EnableMacieRequest = {
    import EnableMacieRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.EnableMacieRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(findingPublishingFrequency.map(value => value.unwrap))(
        _.findingPublishingFrequency
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.EnableMacieRequest.ReadOnly =
    zio.aws.macie2.model.EnableMacieRequest.wrap(buildAwsValue())
}
object EnableMacieRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.EnableMacieRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.EnableMacieRequest =
      zio.aws.macie2.model.EnableMacieRequest(
        clientToken.map(value => value),
        findingPublishingFrequency.map(value => value),
        status.map(value => value)
      )
    def clientToken: Option[__string]
    def findingPublishingFrequency
        : Option[zio.aws.macie2.model.FindingPublishingFrequency]
    def status: Option[zio.aws.macie2.model.MacieStatus]
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFindingPublishingFrequency
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingPublishingFrequency] =
      AwsError.unwrapOptionField(
        "findingPublishingFrequency",
        findingPublishingFrequency
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.macie2.model.MacieStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.EnableMacieRequest
  ) extends zio.aws.macie2.model.EnableMacieRequest.ReadOnly {
    override val clientToken: Option[__string] =
      scala.Option(impl.clientToken()).map(value => value: __string)
    override val findingPublishingFrequency
        : Option[zio.aws.macie2.model.FindingPublishingFrequency] = scala
      .Option(impl.findingPublishingFrequency())
      .map(value => zio.aws.macie2.model.FindingPublishingFrequency.wrap(value))
    override val status: Option[zio.aws.macie2.model.MacieStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.macie2.model.MacieStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.EnableMacieRequest
  ): zio.aws.macie2.model.EnableMacieRequest.ReadOnly = new Wrapper(impl)
}
