package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeclineInvitationsResponse(
    unprocessedAccounts: Option[
      Iterable[zio.aws.macie2.model.UnprocessedAccount]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse = {
    import DeclineInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse
      .builder()
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DeclineInvitationsResponse.ReadOnly =
    zio.aws.macie2.model.DeclineInvitationsResponse.wrap(buildAwsValue())
}
object DeclineInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DeclineInvitationsResponse =
      zio.aws.macie2.model.DeclineInvitationsResponse(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedAccounts
        : Option[List[zio.aws.macie2.model.UnprocessedAccount.ReadOnly]]
    def getUnprocessedAccounts: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.UnprocessedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse
  ) extends zio.aws.macie2.model.DeclineInvitationsResponse.ReadOnly {
    override val unprocessedAccounts
        : Option[List[zio.aws.macie2.model.UnprocessedAccount.ReadOnly]] = scala
      .Option(impl.unprocessedAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.UnprocessedAccount.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse
  ): zio.aws.macie2.model.DeclineInvitationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
