package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters.*
final case class BucketCriteriaAdditionalProperties(
    eq: Option[Iterable[__string]] = None,
    gt: Option[__long] = None,
    gte: Option[__long] = None,
    lt: Option[__long] = None,
    lte: Option[__long] = None,
    neq: Option[Iterable[__string]] = None,
    prefix: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties = {
    import BucketCriteriaAdditionalProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties
      .builder()
      .optionallyWith(
        eq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eq)
      .optionallyWith(gt.map(value => value: java.lang.Long))(_.gt)
      .optionallyWith(gte.map(value => value: java.lang.Long))(_.gte)
      .optionallyWith(lt.map(value => value: java.lang.Long))(_.lt)
      .optionallyWith(lte.map(value => value: java.lang.Long))(_.lte)
      .optionallyWith(
        neq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.neq)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly =
    zio.aws.macie2.model.BucketCriteriaAdditionalProperties
      .wrap(buildAwsValue())
}
object BucketCriteriaAdditionalProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketCriteriaAdditionalProperties =
      zio.aws.macie2.model.BucketCriteriaAdditionalProperties(
        eq.map(value => value),
        gt.map(value => value),
        gte.map(value => value),
        lt.map(value => value),
        lte.map(value => value),
        neq.map(value => value),
        prefix.map(value => value)
      )
    def eq: Option[List[__string]]
    def gt: Option[__long]
    def gte: Option[__long]
    def lt: Option[__long]
    def lte: Option[__long]
    def neq: Option[List[__string]]
    def prefix: Option[__string]
    def getEq: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("eq", eq)
    def getGt: ZIO[Any, AwsError, __long] = AwsError.unwrapOptionField("gt", gt)
    def getGte: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("gte", gte)
    def getLt: ZIO[Any, AwsError, __long] = AwsError.unwrapOptionField("lt", lt)
    def getLte: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("lte", lte)
    def getNeq: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("neq", neq)
    def getPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties
  ) extends zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly {
    override val eq: Option[List[__string]] = scala
      .Option(impl.eq())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val gt: Option[__long] =
      scala.Option(impl.gt()).map(value => value: __long)
    override val gte: Option[__long] =
      scala.Option(impl.gte()).map(value => value: __long)
    override val lt: Option[__long] =
      scala.Option(impl.lt()).map(value => value: __long)
    override val lte: Option[__long] =
      scala.Option(impl.lte()).map(value => value: __long)
    override val neq: Option[List[__string]] = scala
      .Option(impl.neq())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val prefix: Option[__string] =
      scala.Option(impl.prefix()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketCriteriaAdditionalProperties
  ): zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly =
    new Wrapper(impl)
}
