package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__boolean
import scala.jdk.CollectionConverters.*
final case class BlockPublicAccess(
    blockPublicAcls: Option[__boolean] = None,
    blockPublicPolicy: Option[__boolean] = None,
    ignorePublicAcls: Option[__boolean] = None,
    restrictPublicBuckets: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BlockPublicAccess = {
    import BlockPublicAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BlockPublicAccess
      .builder()
      .optionallyWith(blockPublicAcls.map(value => value: java.lang.Boolean))(
        _.blockPublicAcls
      )
      .optionallyWith(blockPublicPolicy.map(value => value: java.lang.Boolean))(
        _.blockPublicPolicy
      )
      .optionallyWith(ignorePublicAcls.map(value => value: java.lang.Boolean))(
        _.ignorePublicAcls
      )
      .optionallyWith(
        restrictPublicBuckets.map(value => value: java.lang.Boolean)
      )(_.restrictPublicBuckets)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BlockPublicAccess.ReadOnly =
    zio.aws.macie2.model.BlockPublicAccess.wrap(buildAwsValue())
}
object BlockPublicAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BlockPublicAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BlockPublicAccess =
      zio.aws.macie2.model.BlockPublicAccess(
        blockPublicAcls.map(value => value),
        blockPublicPolicy.map(value => value),
        ignorePublicAcls.map(value => value),
        restrictPublicBuckets.map(value => value)
      )
    def blockPublicAcls: Option[__boolean]
    def blockPublicPolicy: Option[__boolean]
    def ignorePublicAcls: Option[__boolean]
    def restrictPublicBuckets: Option[__boolean]
    def getBlockPublicAcls: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("blockPublicAcls", blockPublicAcls)
    def getBlockPublicPolicy: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("blockPublicPolicy", blockPublicPolicy)
    def getIgnorePublicAcls: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("ignorePublicAcls", ignorePublicAcls)
    def getRestrictPublicBuckets: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("restrictPublicBuckets", restrictPublicBuckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BlockPublicAccess
  ) extends zio.aws.macie2.model.BlockPublicAccess.ReadOnly {
    override val blockPublicAcls: Option[__boolean] =
      scala.Option(impl.blockPublicAcls()).map(value => value: __boolean)
    override val blockPublicPolicy: Option[__boolean] =
      scala.Option(impl.blockPublicPolicy()).map(value => value: __boolean)
    override val ignorePublicAcls: Option[__boolean] =
      scala.Option(impl.ignorePublicAcls()).map(value => value: __boolean)
    override val restrictPublicBuckets: Option[__boolean] =
      scala.Option(impl.restrictPublicBuckets()).map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BlockPublicAccess
  ): zio.aws.macie2.model.BlockPublicAccess.ReadOnly = new Wrapper(impl)
}
