package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UsageStatisticsSortBy(
    key: Option[zio.aws.macie2.model.UsageStatisticsSortKey] = None,
    orderBy: Option[zio.aws.macie2.model.OrderBy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UsageStatisticsSortBy = {
    import UsageStatisticsSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UsageStatisticsSortBy
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(orderBy.map(value => value.unwrap))(_.orderBy)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly =
    zio.aws.macie2.model.UsageStatisticsSortBy.wrap(buildAwsValue())
}
object UsageStatisticsSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UsageStatisticsSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UsageStatisticsSortBy =
      zio.aws.macie2.model.UsageStatisticsSortBy(
        key.map(value => value),
        orderBy.map(value => value)
      )
    def key: Option[zio.aws.macie2.model.UsageStatisticsSortKey]
    def orderBy: Option[zio.aws.macie2.model.OrderBy]
    def getKey
        : ZIO[Any, AwsError, zio.aws.macie2.model.UsageStatisticsSortKey] =
      AwsError.unwrapOptionField("key", key)
    def getOrderBy: ZIO[Any, AwsError, zio.aws.macie2.model.OrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UsageStatisticsSortBy
  ) extends zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly {
    override val key: Option[zio.aws.macie2.model.UsageStatisticsSortKey] =
      scala
        .Option(impl.key())
        .map(value => zio.aws.macie2.model.UsageStatisticsSortKey.wrap(value))
    override val orderBy: Option[zio.aws.macie2.model.OrderBy] = scala
      .Option(impl.orderBy())
      .map(value => zio.aws.macie2.model.OrderBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UsageStatisticsSortBy
  ): zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly = new Wrapper(impl)
}
