package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SessionIssuer(
    accountId: Option[__string] = None,
    arn: Option[__string] = None,
    principalId: Option[__string] = None,
    `type`: Option[__string] = None,
    userName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SessionIssuer = {
    import SessionIssuer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SessionIssuer
      .builder()
      .optionallyWith(
        accountId.map(value => __string.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        principalId.map(value => __string.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(
        `type`.map(value => __string.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        userName.map(value => __string.unwrap(value): java.lang.String)
      )(_.userName)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SessionIssuer.ReadOnly =
    zio.aws.macie2.model.SessionIssuer.wrap(buildAwsValue())
}
object SessionIssuer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SessionIssuer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SessionIssuer =
      zio.aws.macie2.model.SessionIssuer(
        accountId.map(value => value),
        arn.map(value => value),
        principalId.map(value => value),
        `type`.map(value => value),
        userName.map(value => value)
      )
    def accountId: Option[__string]
    def arn: Option[__string]
    def principalId: Option[__string]
    def `type`: Option[__string]
    def userName: Option[__string]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getPrincipalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
    def getUserName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SessionIssuer
  ) extends zio.aws.macie2.model.SessionIssuer.ReadOnly {
    override val accountId: Option[__string] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val principalId: Option[__string] = scala
      .Option(impl.principalId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val `type`: Option[__string] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val userName: Option[__string] = scala
      .Option(impl.userName())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SessionIssuer
  ): zio.aws.macie2.model.SessionIssuer.ReadOnly = new Wrapper(impl)
}
