package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SessionContext(
    attributes: Option[zio.aws.macie2.model.SessionContextAttributes] = None,
    sessionIssuer: Option[zio.aws.macie2.model.SessionIssuer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SessionContext = {
    import SessionContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SessionContext
      .builder()
      .optionallyWith(attributes.map(value => value.buildAwsValue()))(
        _.attributes
      )
      .optionallyWith(sessionIssuer.map(value => value.buildAwsValue()))(
        _.sessionIssuer
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SessionContext.ReadOnly =
    zio.aws.macie2.model.SessionContext.wrap(buildAwsValue())
}
object SessionContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SessionContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SessionContext =
      zio.aws.macie2.model.SessionContext(
        attributes.map(value => value.asEditable),
        sessionIssuer.map(value => value.asEditable)
      )
    def attributes
        : Option[zio.aws.macie2.model.SessionContextAttributes.ReadOnly]
    def sessionIssuer: Option[zio.aws.macie2.model.SessionIssuer.ReadOnly]
    def getAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SessionContextAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("attributes", attributes)
    def getSessionIssuer
        : ZIO[Any, AwsError, zio.aws.macie2.model.SessionIssuer.ReadOnly] =
      AwsError.unwrapOptionField("sessionIssuer", sessionIssuer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SessionContext
  ) extends zio.aws.macie2.model.SessionContext.ReadOnly {
    override val attributes
        : Option[zio.aws.macie2.model.SessionContextAttributes.ReadOnly] = scala
      .Option(impl.attributes())
      .map(value => zio.aws.macie2.model.SessionContextAttributes.wrap(value))
    override val sessionIssuer
        : Option[zio.aws.macie2.model.SessionIssuer.ReadOnly] = scala
      .Option(impl.sessionIssuer())
      .map(value => zio.aws.macie2.model.SessionIssuer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SessionContext
  ): zio.aws.macie2.model.SessionContext.ReadOnly = new Wrapper(impl)
}
