package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters.*
final case class Record(
    jsonPath: Option[__string] = None,
    recordIndex: Option[__long] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Record = {
    import Record.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Record
      .builder()
      .optionallyWith(
        jsonPath.map(value => __string.unwrap(value): java.lang.String)
      )(_.jsonPath)
      .optionallyWith(
        recordIndex.map(value => __long.unwrap(value): java.lang.Long)
      )(_.recordIndex)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Record.ReadOnly =
    zio.aws.macie2.model.Record.wrap(buildAwsValue())
}
object Record {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Record] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Record = zio.aws.macie2.model
      .Record(jsonPath.map(value => value), recordIndex.map(value => value))
    def jsonPath: Option[__string]
    def recordIndex: Option[__long]
    def getJsonPath: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jsonPath", jsonPath)
    def getRecordIndex: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("recordIndex", recordIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Record
  ) extends zio.aws.macie2.model.Record.ReadOnly {
    override val jsonPath: Option[__string] = scala
      .Option(impl.jsonPath())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val recordIndex: Option[__long] = scala
      .Option(impl.recordIndex())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Record
  ): zio.aws.macie2.model.Record.ReadOnly = new Wrapper(impl)
}
