package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutClassificationExportConfigurationResponse(
    configuration: Option[
      zio.aws.macie2.model.ClassificationExportConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse = {
    import PutClassificationExportConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.PutClassificationExportConfigurationResponse.ReadOnly =
    zio.aws.macie2.model.PutClassificationExportConfigurationResponse
      .wrap(buildAwsValue())
}
object PutClassificationExportConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.PutClassificationExportConfigurationResponse =
      zio.aws.macie2.model.PutClassificationExportConfigurationResponse(
        configuration.map(value => value.asEditable)
      )
    def configuration: Option[
      zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly
    ]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse
  ) extends zio.aws.macie2.model.PutClassificationExportConfigurationResponse.ReadOnly {
    override val configuration: Option[
      zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        zio.aws.macie2.model.ClassificationExportConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse
  ): zio.aws.macie2.model.PutClassificationExportConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
