package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.macie2.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListTagsForResourceResponse =
      zio.aws.macie2.model.ListTagsForResourceResponse(tags.map(value => value))
    def tags: Option[Map[__string, __string]]
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse
  ) extends zio.aws.macie2.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.macie2.model.primitives
              .__string(key) -> zio.aws.macie2.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse
  ): zio.aws.macie2.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
