package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListOrganizationAdminAccountsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest = {
    import ListOrganizationAdminAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListOrganizationAdminAccountsRequest.ReadOnly =
    zio.aws.macie2.model.ListOrganizationAdminAccountsRequest
      .wrap(buildAwsValue())
}
object ListOrganizationAdminAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListOrganizationAdminAccountsRequest =
      zio.aws.macie2.model.ListOrganizationAdminAccountsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest
  ) extends zio.aws.macie2.model.ListOrganizationAdminAccountsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.macie2.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest
  ): zio.aws.macie2.model.ListOrganizationAdminAccountsRequest.ReadOnly =
    new Wrapper(impl)
}
