package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class JobDetails(
    isDefinedInJob: Option[zio.aws.macie2.model.IsDefinedInJob] = None,
    isMonitoredByJob: Option[zio.aws.macie2.model.IsMonitoredByJob] = None,
    lastJobId: Option[__string] = None,
    lastJobRunTime: Option[__timestampIso8601] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.JobDetails = {
    import JobDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.JobDetails
      .builder()
      .optionallyWith(isDefinedInJob.map(value => value.unwrap))(
        _.isDefinedInJob
      )
      .optionallyWith(isMonitoredByJob.map(value => value.unwrap))(
        _.isMonitoredByJob
      )
      .optionallyWith(
        lastJobId.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastJobId)
      .optionallyWith(
        lastJobRunTime.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.lastJobRunTime)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.JobDetails.ReadOnly =
    zio.aws.macie2.model.JobDetails.wrap(buildAwsValue())
}
object JobDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.JobDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.JobDetails =
      zio.aws.macie2.model.JobDetails(
        isDefinedInJob.map(value => value),
        isMonitoredByJob.map(value => value),
        lastJobId.map(value => value),
        lastJobRunTime.map(value => value)
      )
    def isDefinedInJob: Option[zio.aws.macie2.model.IsDefinedInJob]
    def isMonitoredByJob: Option[zio.aws.macie2.model.IsMonitoredByJob]
    def lastJobId: Option[__string]
    def lastJobRunTime: Option[__timestampIso8601]
    def getIsDefinedInJob
        : ZIO[Any, AwsError, zio.aws.macie2.model.IsDefinedInJob] =
      AwsError.unwrapOptionField("isDefinedInJob", isDefinedInJob)
    def getIsMonitoredByJob
        : ZIO[Any, AwsError, zio.aws.macie2.model.IsMonitoredByJob] =
      AwsError.unwrapOptionField("isMonitoredByJob", isMonitoredByJob)
    def getLastJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastJobId", lastJobId)
    def getLastJobRunTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastJobRunTime", lastJobRunTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.JobDetails
  ) extends zio.aws.macie2.model.JobDetails.ReadOnly {
    override val isDefinedInJob: Option[zio.aws.macie2.model.IsDefinedInJob] =
      scala
        .Option(impl.isDefinedInJob())
        .map(value => zio.aws.macie2.model.IsDefinedInJob.wrap(value))
    override val isMonitoredByJob
        : Option[zio.aws.macie2.model.IsMonitoredByJob] = scala
      .Option(impl.isMonitoredByJob())
      .map(value => zio.aws.macie2.model.IsMonitoredByJob.wrap(value))
    override val lastJobId: Option[__string] = scala
      .Option(impl.lastJobId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val lastJobRunTime: Option[__timestampIso8601] = scala
      .Option(impl.lastJobRunTime())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.JobDetails
  ): zio.aws.macie2.model.JobDetails.ReadOnly = new Wrapper(impl)
}
