package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetUsageTotalsRequest(timeRange: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest = {
    import GetUsageTotalsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest
      .builder()
      .optionallyWith(
        timeRange.map(value => __string.unwrap(value): java.lang.String)
      )(_.timeRange)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetUsageTotalsRequest.ReadOnly =
    zio.aws.macie2.model.GetUsageTotalsRequest.wrap(buildAwsValue())
}
object GetUsageTotalsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetUsageTotalsRequest =
      zio.aws.macie2.model.GetUsageTotalsRequest(timeRange.map(value => value))
    def timeRange: Option[__string]
    def getTimeRange: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timeRange", timeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest
  ) extends zio.aws.macie2.model.GetUsageTotalsRequest.ReadOnly {
    override val timeRange: Option[__string] = scala
      .Option(impl.timeRange())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest
  ): zio.aws.macie2.model.GetUsageTotalsRequest.ReadOnly = new Wrapper(impl)
}
