package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetFindingsRequest(
    findingIds: Iterable[__string],
    sortCriteria: Option[zio.aws.macie2.model.SortCriteria] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetFindingsRequest = {
    import GetFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetFindingsRequest
      .builder()
      .findingIds(findingIds.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetFindingsRequest.ReadOnly =
    zio.aws.macie2.model.GetFindingsRequest.wrap(buildAwsValue())
}
object GetFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetFindingsRequest =
      zio.aws.macie2.model.GetFindingsRequest(
        findingIds,
        sortCriteria.map(value => value.asEditable)
      )
    def findingIds: List[__string]
    def sortCriteria: Option[zio.aws.macie2.model.SortCriteria.ReadOnly]
    def getFindingIds: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(findingIds)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.SortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsRequest
  ) extends zio.aws.macie2.model.GetFindingsRequest.ReadOnly {
    override val findingIds: List[__string] = impl
      .findingIds()
      .asScala
      .map { item =>
        zio.aws.macie2.model.primitives.__string(item)
      }
      .toList
    override val sortCriteria
        : Option[zio.aws.macie2.model.SortCriteria.ReadOnly] = scala
      .Option(impl.sortCriteria())
      .map(value => zio.aws.macie2.model.SortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsRequest
  ): zio.aws.macie2.model.GetFindingsRequest.ReadOnly = new Wrapper(impl)
}
