package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetFindingsPublicationConfigurationResponse(
    securityHubConfiguration: Option[
      zio.aws.macie2.model.SecurityHubConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationResponse = {
    import GetFindingsPublicationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationResponse
      .builder()
      .optionallyWith(
        securityHubConfiguration.map(value => value.buildAwsValue())
      )(_.securityHubConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.ReadOnly =
    zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse
      .wrap(buildAwsValue())
}
object GetFindingsPublicationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse =
      zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse(
        securityHubConfiguration.map(value => value.asEditable)
      )
    def securityHubConfiguration
        : Option[zio.aws.macie2.model.SecurityHubConfiguration.ReadOnly]
    def getSecurityHubConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SecurityHubConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "securityHubConfiguration",
      securityHubConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationResponse
  ) extends zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.ReadOnly {
    override val securityHubConfiguration
        : Option[zio.aws.macie2.model.SecurityHubConfiguration.ReadOnly] = scala
      .Option(impl.securityHubConfiguration())
      .map(value => zio.aws.macie2.model.SecurityHubConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationResponse
  ): zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
