package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class DescribeBucketsRequest(
    criteria: Option[
      Map[__string, zio.aws.macie2.model.BucketCriteriaAdditionalProperties]
    ] = None,
    maxResults: Option[__integer] = None,
    nextToken: Option[__string] = None,
    sortCriteria: Option[zio.aws.macie2.model.BucketSortCriteria] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest = {
    import DescribeBucketsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest
      .builder()
      .optionallyWith(
        criteria.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.criteria)
      .optionallyWith(
        maxResults.map(value => __integer.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DescribeBucketsRequest.ReadOnly =
    zio.aws.macie2.model.DescribeBucketsRequest.wrap(buildAwsValue())
}
object DescribeBucketsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DescribeBucketsRequest =
      zio.aws.macie2.model.DescribeBucketsRequest(
        criteria.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortCriteria.map(value => value.asEditable)
      )
    def criteria: Option[Map[
      __string,
      zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly
    ]]
    def maxResults: Option[__integer]
    def nextToken: Option[__string]
    def sortCriteria: Option[zio.aws.macie2.model.BucketSortCriteria.ReadOnly]
    def getCriteria: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly
    ]] = AwsError.unwrapOptionField("criteria", criteria)
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketSortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest
  ) extends zio.aws.macie2.model.DescribeBucketsRequest.ReadOnly {
    override val criteria: Option[Map[
      __string,
      zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly
    ]] = scala
      .Option(impl.criteria())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.macie2.model.primitives.__string(
              key
            ) -> zio.aws.macie2.model.BucketCriteriaAdditionalProperties
              .wrap(value)
          })
          .toMap
      )
    override val maxResults: Option[__integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.macie2.model.primitives.__integer(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val sortCriteria
        : Option[zio.aws.macie2.model.BucketSortCriteria.ReadOnly] = scala
      .Option(impl.sortCriteria())
      .map(value => zio.aws.macie2.model.BucketSortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest
  ): zio.aws.macie2.model.DescribeBucketsRequest.ReadOnly = new Wrapper(impl)
}
